unit Mdrep;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Quickrep, DB, DBTables, ExtCtrls, Buttons, Spin;

type
  TMDForm = class(TForm)
    MDRep: TQuickReport;
    Title: TQRBand;
    CustomerHeading: TQRBand;
    QRDBText1: TQRDBText;
    QRLabel3: TQRLabel;
    QRLabel4: TQRLabel;
    QRDBText3: TQRDBText;
    QRDBText4: TQRDBText;
    QRLabel5: TQRLabel;
    QRDBText5: TQRDBText;
    CustomerFooter: TQRBand;
    QRDBCalc1: TQRDBCalc;
    QRLabel7: TQRLabel;
    PageFooter: TQRBand;
    QRSysData1: TQRSysData;
    Summary: TQRBand;
    QRSysData2: TQRSysData;
    OrderDetail: TQRBand;
    QRDBText2: TQRDBText;
    QRDBText7: TQRDBText;
    QRDBCalc2: TQRDBCalc;
    QRLabel6: TQRLabel;
    CustomerTable: TTable;
    OrdersTable: TTable;
    CustomerDS: TDataSource;
    OrderDS: TDataSource;
    OrdersTableOrderNo: TFloatField;
    OrdersTableSaleDate: TDateTimeField;
    OrdersTableItemsTotal: TCurrencyField;
    OrdersTableTaxRate: TFloatField;
    OrdersTableFreight: TCurrencyField;
    OrdersTableAmountPaid: TCurrencyField;
    CustomerTableCustNo: TFloatField;
    CustomerTableCompany: TStringField;
    CustomerTablePhone: TStringField;
    CustomerTableFAX: TStringField;
    CustomerTableContact: TStringField;
    OrdersTableCustNo: TFloatField;
    QRLabel15: TQRLabel;
    Image1: TImage;
    QRLabel1: TQRLabel;
    QRLabel16: TQRLabel;
    QRDetailLink1: TQRDetailLink;
    QRDetailLink2: TQRDetailLink;
    ItemsTable: TTable;
    ItemsDS: TDataSource;
    ItemsTableOrderNo: TFloatField;
    ItemsTableItemNo: TFloatField;
    ItemsTablePartNo: TFloatField;
    ItemsTableQty: TIntegerField;
    ItemsTableDiscount: TFloatField;
    ItemsDetail: TQRBand;
    PartsTable: TTable;
    PartsDS: TDataSource;
    PartsTablePartNo: TFloatField;
    PartsTableVendorNo: TFloatField;
    PartsTableDescription: TStringField;
    PartsTableOnHand: TFloatField;
    PartsTableOnOrder: TFloatField;
    PartsTableCost: TCurrencyField;
    PartsTableListPrice: TCurrencyField;
    QRLabel2: TQRLabel;
    QRLabel9: TQRLabel;
    QRDBText6: TQRDBText;
    QRDBText9: TQRDBText;
    QRDBText10: TQRDBText;
    ItemsTableTotal: TCurrencyField;
    ItemsTableTotalAmount: TCurrencyField;
    QRDBText11: TQRDBText;
    QRDBText12: TQRDBText;
    QRLabel10: TQRLabel;
    QRLabel11: TQRLabel;
    QRLabel12: TQRLabel;
    QRLabel13: TQRLabel;
    QRLabel14: TQRLabel;
    QRShape1: TQRShape;
    QRShape2: TQRShape;
    QRShape3: TQRShape;
    QRShape4: TQRShape;
    QRShape5: TQRShape;
    OrderFooter: TQRBand;
    QRLabel17: TQRLabel;
    QRShape6: TQRShape;
    QRDBText13: TQRDBText;
    procedure ItemsTableCalcFields(DataSet: TDataset);
    procedure ItemsDetailBeforePrint(var PrintBand: Boolean);
    procedure ItemsDetailAfterPrint(BandPrinted: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MDForm: TMDForm;

implementation

{$R *.DFM}

procedure TMDForm.ItemsTableCalcFields(DataSet: TDataset);
begin
   {ItemsTableTotalAmount.Value:=ItemsTableQty.AsFloat*PartsTableListPrice.AsFloat;}

   { Due to some strange bug the last detail table isn't always updated right so
     we moved this to the BeforePrint event of the ItemsDetailBand}
end;

procedure TMDForm.ItemsDetailBeforePrint(var PrintBand: Boolean);
begin
   { This should really go into the ItemsTableOncalcFields event handler but that
     doesn't work correctly, by some strange reason}
   ItemsTable.Edit;
   ItemsTableTotalAmount.Value:=ItemsTableQty.AsFloat*PartsTableListPrice.AsFloat;
end;
procedure TMDForm.ItemsDetailAfterPrint(BandPrinted: Boolean);
begin
    ItemsTable.Cancel;
end;

end.
